<div class="container">
    <div class="row">
        <div class="col-12 mx-auto mt-5">
            <form action="{{ route('patient.register') }}" method="POST" id="register-form" enctype="multipart/form-data">
                @csrf
                <span class="h3 text-gold-light fw-light mb-5">{{ __('patient/register.form.title') }}</span>
                <div class="form-group mt-3">
                    <span>{{ __('patient/register.form.member') }}</span>
                    <a href="{{ route('patient.login') }}" class="text-gold-light">
                        {{ __('patient/register.form.login') }}
                    </a>
                </div>
                <div class="mt-5 mb-3 row">
                    <div class="col-12 mb-3">
                        <span class="fs-5 fw-light text-gold-light">{{ __('patient/register.form.full_name') }}</span>
                    </div>
                    <div class="col-12 col-md-6 col-lg-4 col-xxl-3 mb-3">
                        <label for="first-name" class="form-label required">
                            {{ __('patient/register.form.first_name') }}
                        </label>
                        <input type="text" name="first-name" class="form-control" id="first-name"
                            value="{{ old('first-name') }}">
                    </div>
                    <div class="col-12 col-md-6 col-lg-4 col-xxl-3 mb-3">
                        <label for="last-name" class="form-label required">
                            {{ __('patient/register.form.last_name') }}
                        </label>
                        <input type="text" name="last-name" class="form-control" id="last-name"
                            value="{{ old('last-name') }}">
                    </div>
                </div>
                <div class="mt-4 row">
                    <div class="col-12 col-xl-6">
                        <div class="mb-3 row">
                            <div class="col-12 mb-3">
                                <span class="fs-5 fw-light text-gold-light">
                                    {{ __('patient/register.form.contact_info') }}
                                </span>
                            </div>
                            <div class="col-12 col-lg-6 mb-3">
                                <label for="mobile"
                                    class="form-label required">{{ __('patient/register.form.mobile') }}</label>
                                <input type="text" name="mobile" class="form-control" id="mobile"
                                    value="{{ old('mobile') }}">
                            </div>
                            <div class="col-12 col-lg-6 mb-3">
                                <label for="region" class="form-label required">
                                    {{ __('patient/register.form.region') }}
                                </label>
                                <select name="region" id="region" class="form-select">
                                    @foreach ($regions as $region)
                                        <option value="{{ $region->id }}">{{ $region->region }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-xl-6">
                        <div class="mb-3 row">
                            <div class="col-12 mb-3">
                                <span class="fs-5 fw-light text-gold-light">
                                    {{ __('patient/register.form.dob_title') }}
                                </span>
                            </div>
                            <div class="col-12 col-lg-6 mb-3">
                                <label for="dob"
                                    class="form-label required">{{ __('patient/register.form.dob') }}</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="dob" id="dob" class="form-control"
                                        placeholder="Year-Month-Day" aria-label="YYYY-MM-DD"
                                        aria-describedby="dob-addon" value="{{ old('dob') }}">
                                    <span class="input-group-text" id="dob-addon">
                                        <i class="fas fa-calendar"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="col-12 col-lg-6 mb-3">
                                <label for="gender" class="form-label required">
                                    {{ __('patient/register.form.gender') }}
                                </label>
                                <select name="gender" id="gender" class="form-select">
                                    <option value="f" @if (old('gender') == 'f') selected @endif>
                                        {{ __('patient/common.gender.female') }}</option>
                                    <option value="m" @if (old('gender') == 'm') selected @endif>{{ __('patient/common.gender.male') }}
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-xl-6">
                        <div class="mb-3 row">
                            <div class="col-12 mb-3">
                                <span
                                    class="fs-5 fw-light text-gold-light">{{ __('patient/register.form.account_info') }}</span>
                            </div>
                            <div class="col-12 col-lg-6 mb-3">
                                <label for="password" class="form-label required">
                                    {{ __('patient/register.form.password') }}
                                </label>
                                <div class="input-group mb-3">
                                    <input type="password" name="password" id="password" class="form-control"
                                        data-visibile="false" aria-describedby="toggle-password">
                                    <button class="btn btn-light" type="button" id="toggle-password">
                                        <i class="far fa-eye-slash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mb-3 row">
                    <div class="col-12">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="1" name="credibility"
                                id="credibility">
                            <label class="form-check-label" for="credibility">
                                {{ __('patient/register.form.credibility') }}
                            </label>
                        </div>
                    </div>
                </div>
                <button type="button" onclick="otpSend();" class="btn btn-gold mt-4">{{ __('patient/register.form.register') }}</button>
                <div class="text-center mt-4">
                    <p class="">or sign up with</p>
                    <a type="button" class="btn btn-gold btn-floating mx-1">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a type="button" class="btn btn-gold btn-floating mx-1">
                        <i class="fab fa-google"></i>
                    </a>
                </div>
            </form>
        </div>
        <div class="modal fade" id="otp-modal" tabindex="-1" aria-labelledby="otp-modalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="otp-modalLabel">Modal title</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="recaptcha-container"></div>
                    <input type="text" id="otp-code" class="form-control" placeholder="Enter OTP Code">
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                  <button type="button" onclick="otpVerify();" class="btn btn-primary">Save changes</button>
                </div>
              </div>
            </div>
          </div>
    </div>
    <script>
        $(document).ready(function() {
            var start_date = moment().subtract(70, "years").format("YYYY-MM-DD");
            var default_date = moment().subtract(25, "years").format("YYYY-MM-DD");

            $('#dob').datepicker({
                format: 'yyyy-mm-dd',
                endDate: '0d',
                startdate: start_date,
                defaultViewDate: default_date,
            });

            $('#toggle-password').on('click', function(e) {

                e.preventDefault();

                let pass_field = $('#password');

                if (pass_field.data('visibile') == 'true') {
                    pass_field.data('visibile', 'false');
                    pass_field.attr('type', 'password');
                    $(this).html('<i class="far fa-eye-slash"></i>');
                } else {
                    pass_field.data('visibile', 'true');
                    pass_field.attr('type', 'text');
                    $(this).html('<i class="far fa-eye"></i>');

                }

            });
        });
    </script>
        @section('scripts')
        <script src="https://www.gstatic.com/firebasejs/9.6.6/firebase-app-compat.js"></script>
        <script src="https://www.gstatic.com/firebasejs/9.6.6/firebase-auth-compat.js"></script>
        <script>
            const firebaseConfig = {
                apiKey: "AIzaSyDGZep9UYMKb5hubx4ZXWc1C97Z0YREpBU",
                authDomain: "zain-clinic.firebaseapp.com",
                projectId: "zain-clinic",
                storageBucket: "zain-clinic.appspot.com",
                messagingSenderId: "479149046768",
                appId: "1:479149046768:web:f0cda4c8d5eca1f1393b35",
                measurementId: "G-K6741GNZNR"
            };

            firebase.initializeApp(firebaseConfig);
            /*   const app = initializeApp(firebaseConfig);
              const analytics = getAnalytics(app); */
        </script>
        <script type="text/javascript">
            // reCAPTCHA widget    
            window.recaptchaVerifier = new firebase.auth.RecaptchaVerifier('recaptcha-container', {
                'size': 'invisible',
                'callback': (response) => {
                    // reCAPTCHA solved, allow signInWithPhoneNumber.
                    onSignInSubmit();
                }
            });

            function otpSend() {
                var phoneNumber = '+972'+document.getElementById('mobile').value;
                const appVerifier = window.recaptchaVerifier;
                firebase.auth().signInWithPhoneNumber(phoneNumber, appVerifier)
                    .then((confirmationResult) => {
                        // SMS sent. Prompt user to type the code from the message, then sign the
                        // user in with confirmationResult.confirm(code).
                        window.confirmationResult = confirmationResult;

                        document.getElementById("sent-message").innerHTML = "Message sent succesfully.";
                        document.getElementById("sent-message").classList.add("d-block");

                        $('#otp-modal').modal('show');
                    }).catch((error) => {
                        document.getElementById("error-message").innerHTML = error.message;
                        document.getElementById("error-message").classList.add("d-block");
                    });
            }

            function otpVerify() {
                var code = document.getElementById('otp-code').value;
                confirmationResult.confirm(code).then(function(result) {
                    // User signed in successfully.
                    var user = result.user;

                    document.getElementById("sent-message").innerHTML = "You are succesfully logged in.";
                    document.getElementById("sent-message").classList.add("d-block");

                    $('#register-form').submit();

                }).catch(function(error) {
                    document.getElementById("error-message").innerHTML = error.message;
                    document.getElementById("error-message").classList.add("d-block");
                });
            }
        </script>
    @endsection
</div>
